#ifndef P2P_GL_TEST3_XCODER_H
#define P2P_GL_TEST3_XCODER_H

#include <linux/dma-buf.h>
#include <sys/ioctl.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <iostream>

extern "C"
{
#include <ni_device_api.h>
}


/*!****************************************************************************
    *  \brief  Open an upload session to Quadra
    *
    *  \param  [out] p_upl_ctx   pointer to an upload context of the open session
    *          [in]  iXcoderGUID pointer to  Quadra card hw id
    *          [in]  width       width of the frames
    *          [in]  height      height of the frames
    *          [in]  format      format of the picture
    *          [in]  pool_size   the buffer pool size
    *
    *  \return 0 if successful, < 0 otherwise
    ******************************************************************************/
int uploader_open_session_gl_test(ni_session_context_t *p_upl_ctx, int *iXcoderGUID,
                            int width, int height, ni_pix_fmt_t format, int pool_size);


/*!****************************************************************************
 *  \brief  Prepare frames to simulate P2P transfers
 *
 *  \param [in] p_upl_ctx           pointer to caller allocated uploader
 *                                  session context
 *         [in] input_video_width   video width
 *         [in] input_video_height  video height
 *         [out] p2p_frame          array of hw frames
 *         [in]  pool_size          the size of p2p_frame array
 *
 *  \return  0  on success
 *          -1  on error
 ******************************************************************************/
int p2p_prepare_frames_gl_test(ni_session_context_t *p_upl_ctx, int input_video_width,
                       int input_video_height, ni_frame_t p2p_frame[], int pool_size);

/*!****************************************************************************
 *  \brief  Open an encoder session to Quadra
 *
 *  \param  [out] p_enc_ctx         pointer to an encoder session context
 *          [in]  dst_codec_format  AVC or HEVC
 *          [in]  iXcoderGUID       id to identify the Quadra device
 *          [in]  p_enc_params      sets the encoder parameters
 *          [in]  width             width of frames to encode
 *          [in]  height            height of frames to encode
 *          [in]  p_frame           the first frame
 *
 *  \return 0 if successful, < 0 otherwise
 ******************************************************************************/
int encoder_open_session_gl_test(ni_session_context_t *p_enc_ctx, ni_pix_fmt_t pixel_format, int dst_codec_format,
                         int iXcoderGUID, ni_xcoder_params_t *p_enc_params,
                         int width, int height, ni_frame_t *p_frame);

/*!****************************************************************************
*  \brief  Recycle hw frames back to Quadra
*
*  \param [in] p2p_frame - array of hw frames to recycle
*         [in] pool_size - size of the p2p_frame array
*
*  \return  Returns the number of hw frames that have been recycled
*******************************************************************************/
int recycle_frames_gl_test(ni_frame_t p2p_frame[], const int pool_size);

/*!****************************************************************************
 *  \brief  Send the Quadra encoder a hardware frame which triggers
 *          Quadra to encode the frame
 *
 *  \param  [in] p_enc_ctx              pointer to encoder context
 *          [in] p_in_frame             pointer to hw frame
 *          [in] input_exhausted        flag indicating this is the last frame
 *          [in/out] need_to_resend     flag indicating need to re-send
 *          [in/out] eos_sent           if to send eos
 *
 *  \return  0 on success
 *          -1 on failure
 ******************************************************************************/
int encoder_encode_frame_gl_test(ni_session_context_t *p_enc_ctx,
                         ni_frame_t *p_in_frame, int input_exhausted,
                         int &need_to_resend, int &eos_sent);



/*!****************************************************************************
 *  \brief  Receive output packet data from the Quadra encoder
 *
 *  \param  [in] p_enc_ctx              pointer to encoder session context
 *          [in] p_out_data             pointer to output data session
 *          [in] p_file                 pointer to file to write the packet
 *          [out] total_bytes_received  running counter of bytes read
 *          [in] print_time             1 = print the time
 *
 *  \return 0 - success got packet
 *          1 - received eos
 *          2 - got nothing, need retry
 *         -1 - failure
 ******************************************************************************/
int encoder_receive_data_gl_test(ni_session_context_t *p_enc_ctx,
                         ni_session_data_io_t *p_out_data, FILE *p_file);

/*!****************************************************************************
 *  \brief  Get dma_buf_fd from niFrameSurface1_t
 *
 *  \param  [in] p2p_frame              pointer to niFrameSurface1_t array
 *          [in] i                      position in the array
 *          [in] dup_fd                 if to dup the fd
 *
 *  \return the fd
 *        
 ******************************************************************************/
int get_fd_from_ni_frame(ni_frame_t *p2p_frame, bool dup_fd);

#endif
