## p2p opengl sample

### Hardware requirements
1) gfx9 above AMD GPU
2) NetInt Quadra Encoder (T1, T2, T4)

### Dependencies

#### Opengl driver and opengl develop packages

Using `glxinfo` to Check the information of Opengl.

If the OpenGL driver is not installed in your environment try to install it based on your GPU.

GBM (Generic Buffer Management) is needed in this demo.

For develop packages.

On Ubuntu-22.04 install

mesa-common-dev libglu1-mesa-dev freeglut3-dev mesa-utils
libegl1-mesa-dev libglfw3-dev libsdl2-dev libglew-dev
libdrm-dev libgles2-mesa-dev libgbm-dev

#### NetInt software stack

1）extract NetInt’s package

2） build NetInt dma-buf kernel driver and install
``` bash
cd dma-buf
make -j
insmod netint.ko. # Need to redo it after reboot
```

3）build NetInt libxcoder
``` bash
cd libxcoder
./build.sh # results in directory `build`
```

4）initialize NetInt encoder card resources
``` bash
sudo ./build/init_rsrc # Need to redo it after reboot
```

5）extract NetInt’s release, and install firmware
```
----------/quadra_quick_installer.sh
...
```

``` bash
./quadra_quick_installer.sh # follow the prompt to install firmware
```

### Build 

```bash
cd p2p_read_gbm_egl
make
```

### Run
Parameters:
```
--drm_device=/absolute/path/to/drm/device
#set the path of drm device
#defaut: ""

--output=path/to/output
#set the path of output of this demo
#defalut: p2p_read_gbm_egl_test.h265

--alloc_strategy=<0,1,2>
#set the memory allocate strategy of encoder, may be usefull to improve the total fps,
 recommanded value of --alloc_strategy in this demo is 1
#values: 0,1,2
#default: 0
```

A parameter `--drm_device=XXX` need to be passed to this demo. You can find the drive by run `sudo drm_info -j | jq 'with_entries(.value |= .driver.desc)'`. Then you can get the output like: 

```shell
{
  "/dev/dri/card0": "Intel Graphics"
}
```

To run the demo for encoding:
```bash
sudo EGL_PLATFORM=surfaceless ./p2p_read_gbm_egl --drm_device=/absolute/path/to/drm/device --output=path/to/output
```

To run the demo for down scaling to set some encoder parameter and doing encode:
(The encode parameter need to set in the code)
```bash
sudo EGL_PLATFORM=surfaceless ./p2p_read_gbm_egl --drm_device=/absolute/path/to/drm/device --output=path/to/output --do_scale_and_download
```
